<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Accent extends Model 
{

    protected $table = 'accents';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'status');

    public function job()
    {
        return $this->hasMany('App\Models\Job');
    }

    public function freelanceDetails()
    {
        return $this->hasMany('App\Models\FreelanceDetails');
    }

}